<?php include'invoice_val.php'; ?>

<div class="card-body p-0 overhidden">
    

    <div class="rows p-35 invtem_top_3" style="background: <?php echo html_escape($color) ?>">
        <div class="col-6s text-left">
            <h1 class="mb-1 text-uppercase text-white"><?php echo html_escape($title) ?></h1>
            <p class="text-white"><?php echo html_escape($summary) ?></p>
        </div>


        <div class="col-6s text-right text-white">
            <h5 class="mt-25 text-white mb-0"><?php echo trans('amount-due') ?></h5>
            <h2 class="text-white mt-0">
                <?php if (isset($view_type) && $view_type == 'live'): ?>
                    <?php if ($status == 2){
                        echo price_formatted_alt('0', $this->business->id, $currency_symbol);
                    }else{
                        echo price_formatted_alt($amount_due, $this->business->id, $currency_symbol);
                    } ?>
                <?php else: ?>
                     <?php echo price_formatted_alt('0', $this->business->id, $currency_symbol) ?>
                <?php endif; ?>
            </h2>
        </div>
    </div>

    <div class="rows bill_area flex-parent-between">
        <div class="col-4s">
            <?php if (isset($page) && $page == 'Bill'): ?>
                <h5 class="font-weight-bold"><?php echo trans('purchase-from') ?></h5>
            <?php else: ?>
                <h5 class="font-weight-bold"><?php echo trans('bill-to') ?></h5>
            <?php endif ?>
            
            <?php if (empty($customer_id)): ?>
                <p class="mb-1"><?php echo trans('empty-customer') ?></p>
            <?php else: ?>
                <p class="mb-1">
                    <?php if (!empty(helper_get_customer($customer_id))): ?>
                        <p class="mb-0"><strong><?php echo helper_get_customer($customer_id)->name ?></strong></p>
                        <p class="mt-0 mb-0"><?php echo helper_get_customer($customer_id)->address ?> <?php echo helper_get_customer($customer_id)->country ?></p>
                        <p class="mt-0 mb-0"><?php echo helper_get_customer($customer_id)->phone ?></p>

                        <?php if (!empty($cus_number)): ?>
                        <p class="mt-0 mb-0"><?php echo trans('business-number') ?>: <?php echo html_escape($cus_number) ?></p>
                        <?php endif ?>

                        <?php if (!empty($cus_vat_code)): ?>
                        <p class="mt-0"><?php echo trans('taxvat-number') ?>: <?php echo html_escape($cus_vat_code) ?></p>
                        <?php endif ?>

                    <?php endif ?>
                </p>
            <?php endif ?>
        </div>

        <div class="col-8s text-right">
            <table class="tables">
                <tr>
                    <td><b class="mr-10"><?php if(isset($page) && $page == 'Invoice'){echo trans('invoice-number');}else{echo trans('estimate-number');} ?>:</b></td>
                    <td class="text-left" colspan="1"><?php echo html_escape($number) ?></td>
                </tr>
                <tr>
                    <td><b class="mr-10"><?php if(isset($page) && $page == 'Invoice'){echo trans('invoice-date');}else{echo trans('estimate-date');} ?>:</b></td>
                    <td class="text-left" colspan="1"><?php echo my_date_show($date) ?></td>
                </tr>

                <?php if (!empty($poso_number)): ?>
                <tr>
                    <td><b class="mr-10"><?php echo trans('p.o.s.o.-number') ?>:</b></td>
                    <td class="text-left" colspan="1"><?php echo html_escape($poso_number) ?></td>
                </tr>
                <?php endif ?>

                <?php if(isset($page) && $page == 'Invoice'):?>
                    <tr>
                        <td><b class="mr-10"><?php echo trans('due-date') ?>:</b></td>
                        <td class="text-left">
                            <?php echo my_date_show($payment_due) ?>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="text-left">
                            <?php if ($due_limit == 1): ?>
                                <p><?php echo trans('on-receipt') ?></p>
                            <?php else: ?>
                                <p><?php echo trans('within') ?> <?php echo html_escape($due_limit) ?> <?php echo trans('days') ?></p>
                            <?php endif ?>
                        </td>
                    </tr>
                <?php else: ?>
                    <tr>
                        <td><b class="mr-10"><?php echo trans('expires-on') ?>:</b></td>
                        <td class="text-left">
                        <?php echo my_date_show($invoice->expire_on) ?>
                    </td>
                </tr>
                <?php endif; ?>
            </table>
        </div>
    </div>

    <div class="row p-0 table_area">
        <div class="col-12 table-responsive">
            <table class="table">
                <thead class="pre_head2">
                    <tr class="pre_head_tr2 inv-pl30">
                        <th class="border-0"><?php echo trans('items') ?></th>
                        <th class="border-0"><?php echo trans('price') ?></th>
                        <th class="border-0"><?php echo trans('quantity') ?></th>
                        <th class="border-0"><?php echo trans('amount') ?></th>
                    </tr>
                </thead>
                <tbody>

                    <?php if (isset($page_title) && $page_title == 'Invoice Preview'): ?>
                        <?php if (!empty($this->session->userdata('item'))): ?>
                            <?php $total_items = count($this->session->userdata('item')); ?>
                        <?php else: ?>
                            <?php $total_items = 0; ?>
                        <?php endif ?>
                        
                        <?php if (empty($total_items)): ?>
                            <tr>
                                <td colspan="5" class="text-center"><?php echo trans('empty-items') ?></td>
                            </tr>
                        <?php else: ?>
                            <?php for ($i=0; $i < $total_items; $i++) { ?>
                                <tr class="inv-pl30">
                                    <td class="pl-30" width="50%">
                                    <?php $product_id = $this->session->userdata('item')[$i] ?>
                                    
                                    <?php if (is_numeric($product_id)) {
                                         echo helper_get_product($product_id)->name.'<br> <small>'. nl2br(helper_get_product($product_id)->details).'</small>';
                                    } else {
                                        echo html_escape($product_id);
                                    } ?>
                                    </td>
                                    <td class="pl-30"><?php echo price_formatted_alt($this->session->userdata('price')[$i], $business_id, $currency_symbol) ?></td>
                                    <td class="pl-30"><?php echo $this->session->userdata('quantity')[$i] ?>
                                        
                                        <?php if ($unit_status == 1): ?>
                                            <?php echo $this->session->userdata('unit')[$i] ?>
                                        <?php endif; ?>
                                        
                                    </td>
                                    <td>
                                        <?php echo price_formatted_alt($this->session->userdata('total_price')[$i], $this->business->id, $currency_symbol) ?>   
                                    </td>
                                </tr>
                            <?php } ?>
                        <?php endif ?>

                    <?php else: ?>

                        <?php if ($invoice->parent_id == 0){$invo_id = $invoice->id;}else{$invo_id = $invoice->parent_id;} ?>

                        <?php $items = helper_get_invoice_items($invo_id) ?>
                        <?php if (empty($items)): ?>
                            <tr>
                                <td colspan="5" class="text-center"><?php echo trans('empty-items') ?></td>
                            </tr>
                        <?php else: ?>
                            <?php foreach ($items as $item): ?>
                                <tr class="inv-pl30">
                                    <td class="pl-30" width="50%"><?php echo html_escape($item->item_name) ?> <br> <small><?php echo nl2br($item->details) ?></small></td>
                                    <td><?php echo price_formatted_alt($item->price, $this->business->id, $currency_symbol) ?></td>
                                    <td class="pl-30">
                                        <?php echo html_escape($item->qty) ?> 

                                        <?php if ($unit_status == 1): ?>
                                            <?php echo html_escape($item->type) ?>
                                        <?php endif; ?>
                                    </td>
                                    <td class="pl-30"><?php echo price_formatted_alt($item->total, $this->business->id, $currency_symbol) ?></td>
                                </tr>
                            <?php endforeach ?>
                        <?php endif ?>
                    <?php endif ?>

                    <tr class="inv-pl30">
                        <td></td>
                        <td></td>
                        <td class="text-right"><strong><?php echo trans('sub-total') ?></strong></td>
                        <td class="pl-30"><span><?php echo price_formatted_alt($sub_total, $this->business->id, $currency_symbol) ?></span></td>
                    </tr>

                    <?php if (!empty($taxes)): ?>
                        <?php foreach ($taxes as $tax): ?>
                            <?php if ($tax != 0): ?>
                                <tr class="inv-pl30">
                                    <td></td>
                                    <td></td>
                                    <td class="text-right"><strong><?php echo get_tax_id($tax)->type_name.' ('.get_tax_id($tax)->name.'-'.get_tax_id($tax)->number.') '.get_tax_id($tax)->rate.'%' ?></strong></td>
                                    <td class="pl-30"><span><?php echo price_formatted_alt($sub_total * (get_tax_id($tax)->rate / 100), $this->business->id, $currency_symbol) ?></span></td>
                                </tr>
                            <?php endif ?>
                        <?php endforeach ?>
                    <?php endif ?>
                    
                    <?php if (!empty($discount)): ?>
                        <tr class="inv-pl30">
                            <td></td>
                            <td></td>
                            <td class="text-right"><strong><?php echo trans('discount') ?> <?php echo html_escape($discount) ?>%</strong></td>
                            <td class="pl-30"><span><?php echo price_formatted_alt($sub_total * ($discount / 100), $this->business->id, $currency_symbol) ?></span></td>
                        </tr>
                    <?php endif ?>
                    

                    <tr class="inv-pl30">
                        <td></td>
                        <td></td>
                        <td class="text-right"><strong><?php echo trans('grand-total') ?></strong></td>
                        <td class="pl-30"><span><?php echo price_formatted_alt($grand_total,$this->business->id, $currency_symbol) ?></span></td>
                    </tr>


                    <?php foreach (get_invoice_payments($invoice->id) as $payment): ?>
                        <tr class="inv-pl30 text-dark">
                            <td></td>
                            <td></td>
                            <td class="text-right" width="60%">
                                <span class="fs-13"><strong><?php echo trans('payment-on') ?> <?php echo my_date_show($payment->payment_date) ?> <?php echo trans('using') ?> <?php echo get_using_methods($payment->payment_method) ?></strong></span>
                            </td>
                            <td class="pl-30">
                                <span class="fs-13"><strong><?php echo price_formatted_alt($payment->amount, $this->business->id, $currency_symbol) ?></strong></span>
                            </td>
                        </tr>
                    <?php endforeach ?>

                </tbody>
            </table>
        </div>
    </div>

    <div class="p-30 text-<?php echo html_escape($footer_note_align) ?>">
        <p class="text-centers"><?php echo $footer_note ?></p>
    </div>

    <hr class="my-5">

    <div class="footer3 p-15">
        <?php if (!empty($qr_code)): ?>
            <div class="imgf3">
            <img class="qr_code_sm" src="<?php echo base_url($qr_code) ?>" alt="QR Code">
        </div>
        <?php endif ?>
        <?php if (!empty($logo)): ?>
        <div class="imgf3">
            <img src="<?php echo base_url($logo) ?>" alt="">
        </div>
        <?php endif ?>
   
        <div class="info3">
            <p class="mb-0"><strong><?php echo html_escape($business_name) ?></strong></p>
            <?php if (!empty($biz_number)): ?>
            <p class="mb-0"><?php echo trans('business-number') ?>: <?php echo html_escape($biz_number) ?></p>
            <?php endif ?>

            <?php if (!empty($biz_vat_code)): ?>
            <p class="mb-0"><?php echo trans('taxvat-number') ?>: <?php echo html_escape($biz_vat_code) ?></p>
            <?php endif ?>

            <span class="mt-0 mb-0 invbiz"><?php echo $business_address ?></span>
            <?php if (!empty($business_phone)): ?>
            <p class="mb-0"><?php echo html_escape($business_phone) ?></p>
            <?php endif ?>

            <p class=""><?php echo html_escape($country) ?></p>
        </div>
    </div>
</div>