<div class="content-wrapper">
  <!-- Main content -->
  <section class="content">

    <div class="col-md-6 m-auto box add_area mt-20" style="display: <?php if($page_title == "Edit"){echo "block";}else{echo "none";} ?>">
      <div class="box-header with-border">
        <?php if (isset($page_title) && $page_title == "Edit"): ?>
          <h3 class="box-title">Edit Brand</h3>
        <?php else: ?>
          <h3 class="box-title">Add New Brand</h3>
        <?php endif; ?>

        <div class="box-tools pull-right">
          <?php if (isset($page_title) && $page_title == "Edit"): ?>
            <a href="<?php echo base_url('admin/brand') ?>" class="pull-right btn btn-default btn-sm"><i class="fa fa-angle-left"></i> <?php echo trans('back') ?></a>
          <?php else: ?>
            <a href="#" class="text-right btn btn-default btn-sm cancel_btn"><i class="fa fa-angle-left"></i> <?php echo trans('back') ?></a>
          <?php endif; ?>
        </div>
      </div>

      <div class="box-body">
        <form method="post" enctype="multipart/form-data" action="<?php echo base_url('admin/brand/add')?>" role="form">

          <div class="form-group">
            <label> <?php echo trans('name') ?> <span class="text-danger">*</span></label>
            <input type="text" class="form-control" name="name" value="<?php echo html_escape($brand[0]['name']); ?>" >
          </div>

          <div class="form-group">
            <label> Link <span class="text-danger">*</span></label>
            <input type="text" class="form-control" name="link" value="<?php echo html_escape($brand[0]['link']); ?>" >
          </div>


          <div class="form-group">
              <?php if (isset($page_title) && $page_title == "Edit"): ?>
                  <img src="<?php echo base_url($brand[0]['thumb']) ?>"> <br><br>
              <?php endif ?>
              <div class="input-group">
                  <span class="input-group-btn">
                      <span class="btn btn-info btn-file">
                        <i class="fa fa-cloud-upload"></i> <?php echo trans('upload-image') ?> <input type="file" id="imgInp" name="photo">
                      </span>
                  </span>
              </div><br>
              <img width="200px" id='img-upload'/>
          </div>


          <input type="hidden" name="id" value="<?php echo html_escape($brand['0']['id']); ?>">
          <!-- csrf token -->
          <input type="hidden" name="<?php echo $this->security->get_csrf_token_name();?>" value="<?php echo $this->security->get_csrf_hash();?>">

          <div class="row mb-20">
            <div class="col-sm-12">
              <?php if (isset($page_title) && $page_title == "Edit"): ?>
                <button type="submit" class="btn btn-info pull-left"><?php echo trans('save-changes') ?></button>
              <?php else: ?>
                <button type="submit" class="btn btn-info pull-left"><?php echo trans('save') ?></button>
              <?php endif; ?>
            </div>
          </div>

        </form>

      </div>
    </div>

    <?php if (isset($page_title) && $page_title != "Edit"): ?>

    <div class="list_area container">
        <?php if (isset($page_title) && $page_title == "Edit"): ?>
          <h3 class="box-title">Edit Brandd <a href="<?php echo base_url('admin/brand') ?>" class="pull-right btn btn-primary btn-sm"><i class="fa fa-angle-left"></i> <?php echo trans('back') ?></a></h3>
        <?php else: ?>
          <h3 class="box-title">Brands<a href="#" class="pull-right btn btn-info btn-sm add_btn"><i class="fa fa-plus"></i>Add new Brands</a></h3>
        <?php endif; ?>

        <div class="col-md-12 col-sm-12 col-xs-12 scroll table-responsive p-0">
            <table class="table table-hover cushover <?php if(count($brands) > 10){echo "datatable";} ?>" id="dg_table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo trans('name') ?></th>
                        <th><?php echo trans('image') ?></th>
                        <th>Link</th>
                        <th><?php echo trans('action') ?></th>
                    </tr>
                </thead>
                <tbody>
                  <?php $i=1; foreach ($brands as $brand): ?>
                    <tr id="row_<?php echo html_escape($brand->id); ?>">
                        
                        <td><?php echo $i; ?></td>
                        <td><?php echo html_escape($brand->name) ?></td>
                        <td><img width="100px" src="<?php echo base_url($brand->thumb) ?>"></td>
                        <td><?php echo html_escape($brand->link) ?></td>
                        
                        <td class="actions" width="12%">
                          <a href="<?php echo base_url('admin/brand/edit/'.html_escape($brand->id));?>" class="on-default edit-row" data-placement="top" title="Edit"><i class="fa fa-pencil"></i></a> &nbsp; 

                          <a data-val="brand" data-id="<?php echo html_escape($brand->id); ?>" href="<?php echo base_url('admin/brand/delete/'.html_escape($brand->id));?>" class="on-default remove-row delete_item" data-toggle="tooltip" data-placement="top" title="Delete"><i class="fa fa-trash-o"></i></a> &nbsp;

                        </td>
                    </tr>
                    
                  <?php $i++; endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>

  </section>
</div>
